import 'package:dio/dio.dart';
import 'package:razinsoft_rider/domain/interfaces/order_service_interface.dart';

import '../../core/config/api_endpoints.dart';
import 'api/dio_client.dart';

class OrderService implements IOrderService {
  final DioClient dioClient;
  OrderService({required this.dioClient});

  @override
  Future<Response> createOrder({required Map<String, dynamic> data}) async {
    final response = await dioClient.dio.post(ApiEndpoints.createOrder, data: data);
    return response;
  }
  @override
  Future<Response> orderDetails({required int orderId}) async => await dioClient.dio
        .get('${ApiEndpoints.orderDetails}/$orderId',);

  @override
  Future<Response> checkActiveTrip() async => await dioClient.dio.get(ApiEndpoints.checkActiveTrip,);
}
